'use strict';

/* --------------------------------------------------------------
 product_min_height_fix.js 2016-05-23
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Widget that fixes min height of product info content element
 */
gambio.widgets.module('product_min_height_fix', [gambio.source + '/libs/events'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $window = $(window),
        defaults = {
        productInfoContent: '.product-info-content' // Selector to apply min height to
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    // ########## HELPER FUNCTIONS ##########

    /**
     * Fix for problem that box overlaps content like cross selling products if product content is too short
     *
     * @private
     */
    var _setProductInfoContentMinHeight = function _setProductInfoContentMinHeight() {
        $(options.productInfoContent).css('min-height', $this.outerHeight() + parseFloat($this.css('top')) + 'px');
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {
        _setProductInfoContentMinHeight();

        $window.on(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE(), _setProductInfoContentMinHeight);

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
